#ifndef IEC_IEC_H
#define IEC_IEC_H
/*
**	$VER: iec.h 1.1 (08.10.96)
**	Includes Release 1.1
**
**	Definitions and IECBase
**
**	(C) Copyright 1995-1996 Fabrizio Farenga
**      Email: f.farenga@agora.stm.it 
**	    All Rights Reserved
*/

#include "iec/iec_proto.h"
#include "iec/iec_pragmas.h"

/* STATUS values for the last input/output operations. */
#define ST_OK           0x00 /* OK                 */
#define ST_READ_TIMEOUT 0x02 /* Timeout reading    */
#define ST_TIMEOUT      0x03 /* Timeout            */
#define ST_EOF          0x40 /* End of file        */
#define ST_NOTPRESENT   0x80 /* Device not present */
 
/* Low-Level commands for the 1541 */
#define CMD_DATA        0x60
#define CMD_CLOSE       0xe0
#define CMD_OPEN        0xf0

struct iecbase {
	struct Library LibNode; /* Standard library node */
	ULONG   iec_SysLib;
	ULONG   iec_DosLib;
	ULONG   iec_SegList;

	UBYTE   iec_ST;         //Drive STATUS
	UBYTE   iec_pad;  
				};

#endif
